/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_1306;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_898;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FishingHookConstraint
implements VerletConstraint {
    private Vector3d playerPosAsync = new Vector3d();
    private Vector3d hookPosAsync = new Vector3d();
    private Vector3d playerPos = new Vector3d();
    private Vector3d hookPos = new Vector3d();
    private class_1536 fishingHook;
    private class_1657 player;
    private class_898 entityRenderDispatcher;

    public FishingHookConstraint(VerletSimulation simulation, class_1536 fishingHook, class_1657 player, class_898 entityRenderDispatcher, float tickDelta) {
        int i;
        this.fishingHook = fishingHook;
        this.player = player;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.calculatePlayerAndHookPos(tickDelta, this.playerPos, this.hookPos);
        int pointCount = 48;
        double totalLength = ConfigClient.fishingLineLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp((double)this.playerPos.x, (double)this.hookPos.x, (double)perc), Math.lerp((double)this.playerPos.y, (double)this.hookPos.y, (double)perc), Math.lerp((double)this.playerPos.z, (double)this.hookPos.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            point.rgba.set(0.0f, 0.0f, 0.0f, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    private void calculatePlayerAndHookPos(float tickDelta, Vector3d playerPos, Vector3d hookPos) {
        float playerEyeHeight;
        double playerZ;
        double playerY;
        double playerX;
        double hookX;
        int arm = this.player.method_6068() == class_1306.field_6183 ? 1 : -1;
        class_1799 itemStack = this.player.method_6047();
        if (!itemStack.method_31574(class_1802.field_8378)) {
            arm = -arm;
        }
        float attackRotation = this.player.method_6055(tickDelta);
        float attackRotationSin = class_3532.method_15374((float)(class_3532.method_15355((float)attackRotation) * (float)java.lang.Math.PI));
        float bodyRotation = class_3532.method_16439((float)tickDelta, (float)this.player.field_6220, (float)this.player.field_6283) * ((float)java.lang.Math.PI / 180);
        double bodyRotationSin = class_3532.method_15374((float)bodyRotation);
        double bodyRotationCos = class_3532.method_15362((float)bodyRotation);
        double armShort = (double)arm * 0.35;
        if ((this.entityRenderDispatcher.field_4692 == null || this.entityRenderDispatcher.field_4692.method_31044().method_31034()) && this.player == class_310.method_1551().field_1724) {
            hookX = 960.0 / (double)((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).floatValue();
            class_243 firstPersonOffset = this.entityRenderDispatcher.field_4686.method_36425().method_36427((float)arm * 0.525f, -0.1f);
            firstPersonOffset = firstPersonOffset.method_1021(hookX);
            firstPersonOffset = firstPersonOffset.method_1024(attackRotationSin * 0.5f);
            firstPersonOffset = firstPersonOffset.method_1037(-attackRotationSin * 0.7f);
            playerX = class_3532.method_16436((double)tickDelta, (double)this.player.field_6014, (double)this.player.method_23317()) + firstPersonOffset.field_1352;
            playerY = class_3532.method_16436((double)tickDelta, (double)this.player.field_6036, (double)this.player.method_23318()) + firstPersonOffset.field_1351;
            playerZ = class_3532.method_16436((double)tickDelta, (double)this.player.field_5969, (double)this.player.method_23321()) + firstPersonOffset.field_1350;
            playerEyeHeight = this.player.method_5751();
        } else {
            playerX = class_3532.method_16436((double)tickDelta, (double)this.player.field_6014, (double)this.player.method_23317()) - bodyRotationCos * armShort - bodyRotationSin * 0.8;
            playerY = this.player.field_6036 + (double)this.player.method_5751() + (this.player.method_23318() - this.player.field_6036) * (double)tickDelta - 0.45;
            playerZ = class_3532.method_16436((double)tickDelta, (double)this.player.field_5969, (double)this.player.method_23321()) - bodyRotationSin * armShort + bodyRotationCos * 0.8;
            playerEyeHeight = this.player.method_18276() ? -0.1875f : 0.0f;
        }
        hookX = class_3532.method_16436((double)tickDelta, (double)this.fishingHook.field_6014, (double)this.fishingHook.method_23317());
        double hookY = class_3532.method_16436((double)tickDelta, (double)this.fishingHook.field_6036, (double)this.fishingHook.method_23318()) + 0.25;
        double hookZ = class_3532.method_16436((double)tickDelta, (double)this.fishingHook.field_5969, (double)this.fishingHook.method_23321());
        playerPos.set(playerX, playerY + (double)playerEyeHeight, playerZ);
        hookPos.set(hookX, hookY, hookZ);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        this.calculatePlayerAndHookPos(1.0f, this.playerPosAsync, this.hookPosAsync);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.position.set((Vector3dc)this.playerPosAsync).sub((Vector3dc)simulation.getOffset());
        hookPoint.position.set((Vector3dc)this.hookPosAsync).sub((Vector3dc)simulation.getOffset());
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
        this.calculatePlayerAndHookPos((float)delta, this.playerPos, this.hookPos);
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set((Vector3dc)this.playerPos).sub((Vector3dc)simulation.getOffset());
        armPoint.bufferPrevPosition.set((Vector3dc)armPoint.bufferPosition);
        hookPoint.bufferPosition.set((Vector3dc)this.hookPos).sub((Vector3dc)simulation.getOffset());
        hookPoint.bufferPrevPosition.set((Vector3dc)hookPoint.bufferPosition);
    }

    @Override
    public void renderAfter(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

